/*
 * Decompiled with CFR 0.152.
 */
package de.rafael.modflared.binary.download;

import de.rafael.modflared.Modflared;
import de.rafael.modflared.binary.Cloudflared;
import de.rafael.modflared.binary.download.CloudflaredDownload;
import de.rafael.modflared.github.GithubAPI;
import de.rafael.modflared.tunnel.manager.TunnelManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.Platform;

public class DownloadedCloudflared
extends Cloudflared {
    private final CloudflaredDownload download;
    private static final File VERSION_FILE = new File(TunnelManager.DATA_FOLDER, "version.json");
    private static final String GITHUB_DOWNLOAD_ENDPOINT = "https://github.com/cloudflare/cloudflared/releases/download/";

    public DownloadedCloudflared(CloudflaredDownload download, String version) {
        super(version);
        this.download = download;
    }

    public static CompletableFuture<Cloudflared> tryCreate() {
        if (VERSION_FILE.exists()) {
            try {
                DownloadedCloudflared version = (DownloadedCloudflared)Modflared.GSON.fromJson((Reader)new InputStreamReader(new FileInputStream(VERSION_FILE)), DownloadedCloudflared.class);
                if (version != null) {
                    return CompletableFuture.completedFuture(version);
                }
            }
            catch (Throwable throwable) {
                Modflared.LOGGER.error("Failed to load existing version file creating new one...", throwable);
            }
        }
        return GithubAPI.requestLatestVersion().thenApply(latestVersion -> new DownloadedCloudflared(CloudflaredDownload.find(), (String)latestVersion));
    }

    @Override
    public CompletableFuture<Void> prepare() {
        if (this.isInstalled()) {
            CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
            this.isUptoDate().whenComplete((pair, throwable) -> {
                if (throwable != null) {
                    Modflared.LOGGER.error("Failed to check for updates", throwable);
                    TunnelManager.displayErrorToast();
                    completableFuture.complete(null);
                } else if (!((Boolean)pair.method_15442()).booleanValue()) {
                    Modflared.LOGGER.info("Update detected updating...");
                    this.version = (String)pair.method_15441();
                    this.downloadAndSaveInfo().whenComplete((unused, throwable1) -> {
                        if (throwable1 != null) {
                            Modflared.LOGGER.error("Failed to download update", throwable1);
                        }
                        TunnelManager.displayErrorToast();
                        completableFuture.complete(null);
                    });
                } else {
                    Modflared.LOGGER.info("Cloudflared has no updates :)");
                    completableFuture.complete(null);
                }
            });
            return completableFuture;
        }
        return this.downloadAndSaveInfo();
    }

    @Override
    public String[] buildCommand( @NotNull RunningTunnel.Access access) {
        Object[] command = access.command(this.createBinaryRef().getName(), true);
        Modflared.LOGGER.info(Arrays.toString(command).replace(",", ""));
        if (Platform.get() == Platform.WINDOWS) {
            command[0] = "\"" + TunnelManager.DATA_FOLDER.getAbsolutePath() + "\\" + (String)command[0] + "\"";
        }
        return command;
    }

    private CompletableFuture<Void> downloadAndSaveInfo() {
        return this.downloadFile().thenAccept(unused -> {
            try {
                this.save();
            }
            catch (Throwable throwable) {
                Modflared.LOGGER.error("Failed to save current installed version", throwable);
                TunnelManager.displayErrorToast();
            }
        });
    }

    public boolean isInstalled() {
        return this.createBinaryRef().exists() && VERSION_FILE.exists();
    }

    @Contract(value=" -> new")
    @NotNull
    public File createBinaryRef() {
        return new File(TunnelManager.DATA_FOLDER, this.download.fileName());
    }

    public CompletableFuture<class_3545<Boolean, String>> isUptoDate() {
        return GithubAPI.requestLatestVersion().thenApply(latestVersion -> new class_3545((Object)latestVersion.equals(this.version), latestVersion));
    }

    @NotNull
    public CompletableFuture<Void> downloadFile() {
        return GithubAPI.requestFileHash(this.download.downloadFile()).thenAcceptAsync(fileHash -> {
            try {
                for (int i = 0; i < 5; ++i) {
                    Modflared.LOGGER.info("Downloading cloudflared version {} from github. Attempt: {}", (Object)this.version, (Object)(i + 1));
                    File file = this.syncDownloadFile();
                    if (fileHash.compareTo(file)) {
                        Modflared.LOGGER.info("Download finished of cloudflared version {}!", (Object)this.version);
                        return;
                    }
                    file.delete();
                }
            }
            catch (InterruptedException exception) {
                throw new IllegalStateException("Error while unpacking MacOS cloudflared download", exception);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to download cloudflared binary", exception);
            }
            throw new IllegalStateException("Modflared failed 5 times to download cloudflared from github. Please check your internet connection");
        }, (Executor)Modflared.EXECUTOR);
    }

    @NotNull
    private File syncDownloadFile() throws IOException, InterruptedException {
        File output = new File(TunnelManager.DATA_FOLDER, this.download.fileName());
        if (!output.getParentFile().exists()) {
            output.getParentFile().mkdirs();
        }
        if (!output.exists()) {
            output.createNewFile();
        }
        try (BufferedInputStream in = new BufferedInputStream(URI.create(GITHUB_DOWNLOAD_ENDPOINT + this.version + "/" + this.download.downloadFile()).toURL().openStream());
             BufferedOutputStream fileOutputStream = new BufferedOutputStream(new FileOutputStream(output));){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
            fileOutputStream.flush();
        }
        switch (Platform.get()) {
            case MACOSX: {
                new ProcessBuilder("tar", "-xzf", output.getName()).directory(output.getParentFile()).start().waitFor();
                new ProcessBuilder("mv", "cloudflared", output.getName()).directory(output.getParentFile()).start().waitFor();
            }
            case LINUX: {
                new ProcessBuilder("chmod", "+x", output.getName()).directory(output.getParentFile()).start();
                break;
            }
        }
        return output;
    }

    private void save() throws IOException {
        Files.writeString(VERSION_FILE.toPath(), (CharSequence)Modflared.GSON.toJson((Object)this), StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

