/*
 * Decompiled with CFR 0.152.
 */
package de.rafael.modflared.tunnel.manager;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.rafael.modflared.Modflared;
import de.rafael.modflared.ModflaredPlatform;
import de.rafael.modflared.binary.Cloudflared;
import de.rafael.modflared.interfaces.mixin.IClientConnection;
import de.rafael.modflared.tunnel.RunningTunnel;
import de.rafael.modflared.tunnel.TunnelStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_639;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelManager {
    public static final File BASE_FOLDER = ModflaredPlatform.getGameDir().resolve("modflared/").toFile();
    public static final File DATA_FOLDER = new File(BASE_FOLDER, "bin/");
    public static final File FORCED_TUNNELS_FILE = new File(BASE_FOLDER, "forced_tunnels.json");
    public static final Logger CLOUDFLARE_LOGGER = LoggerFactory.getLogger((String)"Cloudflared");
    private final AtomicReference<Cloudflared> cloudflared = new AtomicReference();
    private final List<class_639> forcedTunnels = new ArrayList<class_639>();
    private final List<RunningTunnel> runningTunnels = new ArrayList<RunningTunnel>();

    public RunningTunnel createTunnel(String host) {
        Cloudflared binary = this.cloudflared.get();
        if (binary != null) {
            Modflared.LOGGER.info("Starting tunnel to {}", (Object)host);
            RunningTunnel process = binary.createTunnel(RunningTunnel.Access.localWithRandomPort(host));
            if (process == null) {
                return null;
            }
            this.runningTunnels.add(process);
            return process;
        }
        return null;
    }

    public void closeTunnel(@NotNull RunningTunnel runningTunnel) {
        Modflared.LOGGER.info("Stopping tunnel to {}", (Object)runningTunnel.access().tunnelAddress());
        this.runningTunnels.remove(runningTunnel);
        runningTunnel.closeTunnel();
    }

    public void closeTunnels() {
        for (RunningTunnel runningTunnel : this.runningTunnels) {
            runningTunnel.closeTunnel();
        }
    }

    @Nullable
    public String shouldUseTunnel(String host) throws IOException {
        if (this.forcedTunnels.stream().anyMatch(serverAddress -> serverAddress.method_2952().equalsIgnoreCase(host))) {
            return host;
        }
        if (!this.isHost(host)) {
            return null;
        }
        try {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            InitialDirContext dirContext = new InitialDirContext(properties);
            Attributes attributes = dirContext.getAttributes(host, new String[]{"TXT"});
            Attribute txtRecords = attributes.get("TXT");
            if (txtRecords != null) {
                NamingEnumeration<?> iterator = txtRecords.getAll();
                while (iterator.hasMore()) {
                    String record = ((String)iterator.next()).replaceAll("\"", "");
                    if (record.startsWith("cloudflared-route=")) {
                        return record.replace("cloudflared-route=", "");
                    }
                    if (!record.equals("cloudflared-use-tunnel")) continue;
                    return host;
                }
            }
        }
        catch (UncheckedIOException | NamingException exception) {
            Modflared.LOGGER.error("Failed to resolve DNS TXT entries: " + exception.getMessage(), (Throwable)exception);
            Modflared.LOGGER.error("Modflared was unable to determine if a tunnel should be used for {} and is defaulting to not using a tunnel", (Object)host);
            Modflared.LOGGER.error("If you believe you need a tunnel for this server, please add it to the forced tunnels list in the modflared folder in your game directory.");
            Modflared.LOGGER.error("For more information, please see the modflared documentation at https://github.com/HttpRafa/modflared?tab=readme-ov-file#versions-100-and-onward");
            throw new IOException(exception);
        }
        return null;
    }

    private boolean isHost(String ip) {
        if (ip.strip().equalsIgnoreCase("localhost")) {
            return false;
        }
        try {
            InetAddress[] ips = InetAddress.getAllByName(ip);
            return ips.length != 1 || !ips[0].getHostAddress().equals(ip);
        }
        catch (UnknownHostException e) {
            return true;
        }
    }

    public void prepareConnection(@NotNull TunnelStatus status, class_2535 connection) {
        IClientConnection tunnelConnection = (IClientConnection)connection;
        if (status.runningTunnel() != null) {
            tunnelConnection.setRunningTunnel(status.runningTunnel());
        }
    }

    public TunnelStatus handleConnect(@NotNull InetSocketAddress address) {
        if (this.cloudflared.get() == null) {
            Modflared.LOGGER.warn("Modflared is not ready yet, ignoring all connections.");
            return new TunnelStatus(null, TunnelStatus.State.DONT_USE);
        }
        RunningTunnel runningTunnel = null;
        TunnelStatus.State state = TunnelStatus.State.DONT_USE;
        String route = null;
        try {
            route = Modflared.TUNNEL_MANAGER.shouldUseTunnel(address.getHostName());
        }
        catch (IOException ignored) {
            state = TunnelStatus.State.FAILED_TO_DETERMINE;
        }
        if (route != null) {
            runningTunnel = Modflared.TUNNEL_MANAGER.createTunnel(route);
            state = TunnelStatus.State.USE;
        }
        return new TunnelStatus(runningTunnel, state);
    }

    public void prepareBinary() {
        Cloudflared.create().whenComplete((version, throwable) -> {
            if (throwable != null) {
                Modflared.LOGGER.error(throwable.getMessage(), throwable);
            } else {
                version.prepare().whenComplete((unused, throwable1) -> {
                    if (throwable1 != null) {
                        Modflared.LOGGER.error(throwable1.getMessage(), throwable1);
                        TunnelManager.displayErrorToast();
                    } else {
                        this.cloudflared.set((Cloudflared)version);
                    }
                });
            }
        });
    }

    public void loadForcedTunnels() {
        this.forcedTunnels.clear();
        if (!FORCED_TUNNELS_FILE.exists()) {
            return;
        }
        try {
            JsonArray entriesArray = JsonParser.parseReader((Reader)new InputStreamReader(new FileInputStream(FORCED_TUNNELS_FILE))).getAsJsonArray();
            for (JsonElement jsonElement : entriesArray) {
                String serverString = jsonElement.getAsString();
                if (!class_639.method_36224((String)serverString)) {
                    Modflared.LOGGER.error("Invalid server address: {}", (Object)serverString);
                    continue;
                }
                this.forcedTunnels.add(class_639.method_2950((String)serverString));
            }
        }
        catch (Exception exception) {
            Modflared.LOGGER.error("Failed to load forced tunnels", (Throwable)exception);
        }
        Modflared.LOGGER.info("Loaded {} forced tunnels", (Object)this.forcedTunnels.size());
        for (class_639 serverAddress : this.forcedTunnels) {
            Modflared.LOGGER.info(" - {}", (Object)serverAddress.method_2952());
        }
    }

    public static void displayErrorToast() {
        class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"gui.toast.title.error"), (class_2561)class_2561.method_43471((String)"gui.toast.body.error")));
    }
}

